# SmartBanner for Shopify

Display location-based pricing banners on your Shopify store to increase global conversions with PPP (Purchasing Power Parity) pricing.

## Installation Methods

### Method 1: App Embed (Recommended - Shopify 2.0 Themes)

This method allows you to configure SmartBanner directly from the Theme Customizer with no code editing.

1. **Download** the `smartbanner.liquid` file from this package

2. **Go to your Shopify Admin** → Online Store → Themes

3. **Click** "Customize" on your active theme

4. **In the theme editor**, click the three dots menu (⋮) → "Edit code"

5. **Navigate to** the `sections` folder

6. **Click** "Add a new section"

7. **Name it** `smartbanner` and paste the contents of `smartbanner.liquid`

8. **Save** the file

9. **Go back** to the Theme Customizer

10. **Click** "App embeds" in the left sidebar (or "Theme settings")

11. **Find** "SmartBanner" and enable it

12. **Enter your API key** and configure settings

13. **Save** your changes

### Method 2: Snippet Installation (All Themes)

This method works with any Shopify theme.

1. **Download** the `smartbanner-snippet.liquid` file

2. **Go to your Shopify Admin** → Online Store → Themes

3. **Click** Actions → Edit code on your active theme

4. **Find** the `snippets` folder and click "Add a new snippet"

5. **Name it** `smartbanner` and paste:

```liquid
{% if settings.smartbanner_enabled and settings.smartbanner_api_key != blank %}
<script
  src="https://smartbanner.pro/embed/v1.js"
  data-key="{{ settings.smartbanner_api_key | escape }}"
  data-position="{{ settings.smartbanner_position | default: 'top' }}"
  data-theme="{{ settings.smartbanner_theme | default: 'auto' }}"
  async>
</script>
{% endif %}
```

6. **Open** `layout/theme.liquid`

7. **Add** this line just before `</head>`:

```liquid
{% render 'smartbanner' %}
```

8. **Open** `config/settings_schema.json`

9. **Add** this settings block to enable Theme Customizer settings:

```json
{
  "name": "SmartBanner",
  "settings": [
    {
      "type": "checkbox",
      "id": "smartbanner_enabled",
      "label": "Enable SmartBanner",
      "default": true
    },
    {
      "type": "text",
      "id": "smartbanner_api_key",
      "label": "API Key",
      "info": "Get your API key at smartbanner.pro"
    },
    {
      "type": "select",
      "id": "smartbanner_position",
      "label": "Position",
      "options": [
        { "value": "top", "label": "Top" },
        { "value": "bottom", "label": "Bottom" },
        { "value": "modal", "label": "Modal" }
      ],
      "default": "top"
    },
    {
      "type": "select",
      "id": "smartbanner_theme",
      "label": "Theme",
      "options": [
        { "value": "auto", "label": "Auto" },
        { "value": "light", "label": "Light" },
        { "value": "dark", "label": "Dark" }
      ],
      "default": "auto"
    }
  ]
}
```

10. **Save** all files

11. **Go to** Theme Customizer → Theme settings → SmartBanner

12. **Enter** your API key and save

### Method 3: Quick Install (Simplest)

Just add this single line to your `theme.liquid` before `</head>`:

```liquid
<script src="https://smartbanner.pro/embed/v1.js" data-key="YOUR_API_KEY" async></script>
```

Replace `YOUR_API_KEY` with your actual SmartBanner API key.

## Configuration Options

| Option | Description | Default |
|--------|-------------|---------|
| `api_key` | Your SmartBanner API key | Required |
| `position` | Banner position: `top`, `bottom`, `modal` | `top` |
| `theme` | Color theme: `auto`, `light`, `dark` | `auto` |
| `delay` | Delay before showing (milliseconds) | `0` |
| `close_button` | Show/hide close button | `true` |
| `bg_color` | Custom background color | Theme default |
| `text_color` | Custom text color | Theme default |
| `accent_color` | Custom accent/button color | Theme default |

## Getting Your API Key

1. Sign up at [smartbanner.pro](https://smartbanner.pro)
2. Go to Dashboard → Settings → API Keys
3. Copy your Live API key (starts with `sb_live_`)

## Automatic Coupon Integration

SmartBanner can automatically apply discount codes at checkout:

1. Go to your SmartBanner Dashboard
2. Navigate to Settings → Integrations
3. Connect your Shopify store
4. Enable "Auto-apply coupons"

This will automatically apply the displayed coupon code when customers proceed to checkout.

## Troubleshooting

### Banner not showing?

1. Check that your API key is correct
2. Verify the banner is enabled in settings
3. Check browser console for errors
4. Make sure you're not on an excluded page

### Discount codes not working?

1. Verify discount codes are set up in Shopify Admin → Discounts
2. Check that codes match those in your SmartBanner dashboard
3. Ensure discounts aren't expired or maxed out

## Support

- Documentation: [smartbanner.pro/docs](https://smartbanner.pro/docs)
- Dashboard: [smartbanner.pro/dashboard](https://smartbanner.pro/dashboard)
- Email: support@smartbanner.pro

## Changelog

### 1.0.0
- Initial release
- Theme section with customizer integration
- All configuration options
- Page exclusion support
